/**
* \file: automounter.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_AUTOMOUNTER_H
#define AAM_CONTROL_AUTOMOUNTER_H

#include <stdbool.h>
#include "automounter_types.h"

typedef void (*callback_func_t)(void);

error_code_t automounter_init(int argc, char *argv[]);

bool automounter_shall_daemonize(void);

error_code_t automounter_mainloop(void);

void automounter_deinit(void);

void automounter_term(void);

void automounter_die_on_resource_issues(void);

#endif
